<?php

class Serfinsa_Gateway
{

    private $sandbox_api_key;

    private $live_api_key;

    private $test_mode;

    private $url_sandbox = 'https://testcheckout.redserfinsa.com:8087';

    private $url_live = 'https://www.serfinsacheckout.com';

    private $form_method;

    private $insertJQuery;

    private $domainName;

//     public function __construct($sandbox_api_key, $live_api_key, $test_mode, $insertJQuery, $form_method)
//     {
//         $this->sandbox_api_key = $sandbox_api_key;
//         $this->live_api_key = $live_api_key;
//         $this->test_mode = $test_mode;
//         $this->form_method = $form_method;
//         $this->insertJQuery = $insertJQuery;
// //         $this->domainName = $domainName;
//     }

    public function __construct($sandbox_api_key, $live_api_key, $test_mode, $insertJQuery, $form_method,$domainName)
    {
        $this->sandbox_api_key = $sandbox_api_key;
        $this->live_api_key = $live_api_key;
        $this->test_mode = $test_mode;
        $this->form_method = $form_method;
        $this->insertJQuery = $insertJQuery;
        $this->domainName = $domainName;
    }

    public function getUrlDomain()
    {
        return ($this->test_mode ? "https://testcheckout.redserfinsa.com:8087" : "https://www.serfinsacheckout.com");
    }

    public function getApiKey()
    {
        return ($this->test_mode ? $this->sandbox_api_key : $this->live_api_key);
    }

    public function getDomainName()
    {
        return $this->domainName;
    }

    function getInsertJQuery()
    {
        return $this->insertJQuery;
    }
    
    function getTetMode(){
        return $test_mode;
    }

    function HTTPPOST($url, $params)
    {
        $query = http_build_query($params);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $query);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSLVERSION, CURL_SSLVERSION_TLSv1_2);
        $response = curl_exec($ch);
        $err = curl_error($ch);
        curl_close($ch);

        return $response;
    }
}